<?php

$parser = new XMLRPCParser();
echo "<h3>Pierwszy przykład</h3>";
$returnedData = $parser->callService('latestDownloadURL', 
		null, 
		'www.upcdatabase.com', 
		'/rpc', 
		80);
		
$parser->processXMLRPCResponse($returnedData);
echo "<h3>Drugi przykład</h3>";
$returnedData = $parser->callService('geocode', 
	'1000 Elysian Park Ave., Los Angeles, CA', 
	'geocoder.us',
	'/service/xmlrpc',
	80); 
$parser->processXMLRPCResponse($returnedData);

class XMLRPCParser {
	
	public function callService($remoteMethod, $parameters, $remoteServer, $remotePath, $port=80) {
		$requestXML = xmlrpc_encode_request($remoteMethod, $parameters);
		$fullRequest = $this->createPostRequest($remoteServer, $remotePath, $requestXML);
		$response = $this->send($remoteServer, $port, $fullRequest);
		return xmlrpc_decode($response);
	}

	private function createPostRequest($remoteServer, $remotePath, $requestBody) {
		
		$theRequest = "POST " . $remotePath . " HTTP/1.0\n" .
		"Host: " . $remoteServer . "\n" .
		"User-Agent: XML-RPC Client\n" .
		"Content-Type: text/xml\n" .
		"Content-Length: " .strlen($requestBody) . "\n" .
		"\n" . $requestBody . "\n";
		return $theRequest;
	}
	
	private function send($remoteServer, $remotePort, $fullXMLRPCRequest) {
		$headers = '';
		$data = '';
		
		$socket = fsockopen($remoteServer, $remotePort);
		fwrite($socket, $fullXMLRPCRequest);
	
		while ($str = trim(fgets($socket))) {
			$headers .= $str . '\n';	
		}
		
		$data = '';
		while  (!feof($socket)) {
			$data .= fgets($socket);	
		}
		fclose($socket);
		return $data;
	
	}
	
	public function processXMLRPCResponse($data) {
		
			if (xmlrpc_is_fault($data)) {
				echo 'Kod błędu: ' . $data['faultCode'] . "\n";
				echo 'Komunikat błędu: ' . $data['faultString'];
			} else {		
				
				if (is_array($data)) {
					var_dump($data);
				} else {
					echo $data;		
				}
				
			}	
			
	}

}

?>